/*********************************************************************
 *
 * Copyright:
 *	1999-2000 MOTOROLA, INC. All Rights Reserved.  
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Motorola, Inc. This 
 *  software is provided on an "AS IS" basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, MOTOROLA 
 *  DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED, INCLUDING 
 *  IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
 *  PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD TO THE 
 *  SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY 
 *  ACCOMPANYING WRITTEN MATERIALS.
 * 
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL MOTOROLA BE LIABLE FOR ANY DAMAGES WHATSOEVER (INCLUDING 
 *  WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS, BUSINESS 
 *  INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER PECUNIARY
 *  LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.   
 * 
 *  Motorola assumes no responsibility for the maintenance and support
 *  of this software
 ********************************************************************/

/*
 * File:		init.h
 * Purpose:		Function prototypes and memory map information.
 *
 * Notes:
 */

#ifndef _INIT_H
#define _INIT_H

/********************************************************************/

/*
 * Debug prints ON (#undef) or OFF (#define)
 */
#undef DEBUG

/* 
 * System Bus Clock Info 
 */
#define	SYSTEM_CLOCK			64		/* system bus frequency in MHz */
#define PERIOD					15.625	/* system bus period in ns */
#define UART_BAUD				115200	/* 115200 */

/* 
 * Memory map definitions from linker command files 
 */
extern uint8 __IPSBAR[];
extern uint8 __SDRAM[];
extern uint8 __SDRAM_SIZE[];
extern uint8 __SRAM[];
extern uint8 __SRAM_SIZE[];
extern uint8 __EXT_SRAM[];
extern uint8 __EXT_SRAM_SIZE[];
extern uint8 __FLASH[];
extern uint8 __FLASH_SIZE[];
extern uint8 __EXT_FLASH[];
extern uint8 __EXT_FLASH_SIZE[];

/* 
 * Memory Map Info 
 */
#define IPSBAR_ADDRESS			(uint32)__IPSBAR

#define SDRAM_ADDRESS			(uint32)__SDRAM
#define SDRAM_SIZE				(uint32)__SDRAM_SIZE

#define SRAM_ADDRESS			(uint32)__SRAM
#define SRAM_SIZE				(uint32)__SRAM_SIZE

#define EXT_SRAM_ADDRESS		(uint32)__EXT_SRAM
#define EXT_SRAM_SIZE			(uint32)__EXT_SRAM_SIZE

#define FLASH_ADDRESS			(uint32)__FLASH
#define FLASH_SIZE				(uint32)__FLASH_SIZE

#define EXT_FLASH_ADDRESS		(uint32)__EXT_FLASH
#define EXT_FLASH_SIZE			(uint32)__EXT_FLASH_SIZE
	
/********************************************************************/

#endif /* _INIT_H */
